/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.problem;

import com.ibm.hwmca.base.pa.vr.VirtualRetainManager;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.pa.fedc.FEDCCollectionAgent;
import com.ibm.hwmca.fw.pa.fedc.FEDCKey;
import com.ibm.hwmca.fw.pa.problem.ProblemCloseHandler;
import com.ibm.hwmca.fw.pa.problem.ProblemCustomerNotifier;
import com.ibm.hwmca.fw.pa.problem.ProblemDataSetAdditionHandler;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.pa.problem.history.HistoryEntry;
import com.ibm.hwmca.fw.service.system.util.ServiceInterfaces;
import com.ibm.hwmca.fw.service.system.util.ServiceInterfacesException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.attention.CommonProblemAttention;
import com.ibm.hwmca.xfw.pa.fedc.FEDCFileDescriptor;
import com.ibm.hwmca.xfw.pa.fedc.FEDCGoodie;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.pa.util.CommonPaLogger;
import com.ibm.hwmca.xfw.pa.util.CommonPaUtils;
import com.ibm.hwmca.xfw.pa.util.ProblemDataDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CommonProblemListener
implements PropertyChangeListener {
    private static final String TRACE_MASKT = "XPACPLIT";
    private static final String TRACE_MASKF = "XPACPLIF";
    private static final String TRACE_MASKD = "XPACPLID";
    private static final String version = "V.8.14.04";
    private static final Class COMMON_PROBLEM_CLASS = class$com$ibm$hwmca$xfw$pa$problem$CommonProblem == null ? (class$com$ibm$hwmca$xfw$pa$problem$CommonProblem = CommonProblemListener.class$("com.ibm.hwmca.xfw.pa.problem.CommonProblem")) : class$com$ibm$hwmca$xfw$pa$problem$CommonProblem;
    static /* synthetic */ Class class$com$ibm$hwmca$xfw$pa$problem$CommonProblem;

    public CommonProblemListener() {
        Trace.trace(TRACE_MASKD, "<--> CommonProblemListner.ctor");
    }

    public void propertyChange(PropertyChangeEvent evt) {
        block54: {
            Trace.trace(TRACE_MASKT, "--> CommonProblemListener.opened()V.8.14.04");
            try {
                Trace.trace(TRACE_MASKF, "got event type " + evt.getPropertyName());
                if (evt.getOldValue() instanceof CommonProblem) {
                    Trace.trace(TRACE_MASKT, "Got a common problem");
                    Trace.trace(TRACE_MASKT, "Got a event for evt.getNewValue ->" + evt.getNewValue());
                    Trace.trace(TRACE_MASKT, "Got a event for evt.getOldValue ->" + evt.getOldValue());
                    Trace.trace(TRACE_MASKT, "Got a event for evt.toString    ->" + evt.toString());
                    Trace.trace(TRACE_MASKT, "source for evt was [" + evt.getSource() + "]");
                    String serviceGoodie = "";
                    String mclGoodie = "";
                    String ffdcGoodie = "";
                    String typeGoodie = "";
                    CommonProblem theProblem = (CommonProblem)evt.getOldValue();
                    if (evt.getPropertyName().equals("ProblemOpenProperty")) {
                        boolean problemChanged = false;
                        Trace.trace(TRACE_MASKF, "got an open");
                        FEDCCollectionAgent agent = null;
                        try {
                            Trace.trace(TRACE_MASKF, "get the FFDC factory");
                            agent = (FEDCCollectionAgent)ServiceInterfaces.getFactory(theProblem.getFailingSystem(), "FEDCCollectionFactory");
                            Trace.trace(TRACE_MASKF, "now get the goodeis");
                            List goodieList = agent.getGoodies(theProblem);
                            Iterator goodieIt = goodieList.iterator();
                            while (goodieIt.hasNext()) {
                                FEDCGoodie goodie = (FEDCGoodie)goodieIt.next();
                                if (goodie.name.toLowerCase().equals("service")) {
                                    serviceGoodie = goodie.value;
                                    Trace.trace(TRACE_MASKF, "got a service goodie of " + goodie.value);
                                    if (serviceGoodie.toLowerCase().equals("n")) {
                                        Trace.trace(TRACE_MASKF, "the service flag was no. Turn of call home.");
                                        theProblem.setCallHome(false);
                                        theProblem.setNotifyCustomer(false);
                                        problemChanged = true;
                                    } else if (serviceGoodie.toLowerCase().equals("y")) {
                                        Trace.trace(TRACE_MASKF, "the service flag was yes. Turn on call home.");
                                        theProblem.setCallHome(true);
                                        theProblem.setNotifyCustomer(true);
                                        problemChanged = true;
                                    } else if (serviceGoodie.toLowerCase().equals("q")) {
                                        Trace.trace(TRACE_MASKF, "the service flag was q. Turn on call home.");
                                        theProblem.setCallHome(false);
                                        theProblem.setNotifyCustomer(true);
                                        problemChanged = true;
                                    } else {
                                        Trace.trace(TRACE_MASKF, "the flag was something else ignore it");
                                    }
                                }
                                if (goodie.name.toLowerCase().equals("mcl")) {
                                    mclGoodie = goodie.value;
                                    Trace.trace(TRACE_MASKF, "got a mcl goodie of " + goodie.value);
                                }
                                if (goodie.name.toLowerCase().equals("ffdc")) {
                                    ffdcGoodie = goodie.value;
                                    Trace.trace(TRACE_MASKF, "got a ffdc goodie of " + goodie.value);
                                }
                                if (!goodie.name.toLowerCase().equals("type")) continue;
                                typeGoodie = goodie.value;
                                Trace.trace(TRACE_MASKF, "got a type goodie of " + goodie.value);
                                theProblem.setProblemType(typeGoodie);
                                problemChanged = true;
                            }
                        }
                        catch (Exception e) {
                            Trace.trace(TRACE_MASKF, "got a fedc collection exception");
                            Trace.trace(TRACE_MASKF, e);
                        }
                        Trace.trace(TRACE_MASKD, "problem.collectffedc is [" + theProblem.isCollectFFDC() + "]");
                        Trace.trace(TRACE_MASKD, "ffdcGoodie is [" + ffdcGoodie + "]");
                        if (theProblem.isCollectFFDC() && !ffdcGoodie.equals("N") && agent != null) {
                            try {
                                ProblemDataDescriptor pdd;
                                VirtualRetainManager vr = VirtualRetainManager.getVirtualRetainManager();
                                Integer problemNumber = new Integer(theProblem.getProblemNumber());
                                String sProblemNumber = problemNumber.toString();
                                problemChanged = true;
                                Trace.trace(TRACE_MASKD, "Creating vr directory for " + sProblemNumber);
                                String dirPath = vr.createDirectory(sProblemNumber);
                                String zipAbsoluteName = vr.queryZipName(sProblemNumber);
                                File zipFile = new File(zipAbsoluteName);
                                String zipName = zipFile.getName();
                                theProblem.setEEDLocation(zipAbsoluteName);
                                Trace.trace(TRACE_MASKD, "they want to collect FFDC data");
                                FEDCKey theKey = theProblem.getFEDCKey();
                                Trace.trace(TRACE_MASKD, "execute any post analysis stuff");
                                agent.postAnalysisExecuteModules(theProblem);
                                Trace.trace(TRACE_MASKD, "get the files to call home");
                                List fileList = agent.getResolvedFileList(theKey);
                                List problemFileList = theProblem.getAssociatedFileList();
                                if (problemFileList != null) {
                                    CommonPaUtils.resolveFileList(problemFileList, fileList);
                                }
                                int fileCount = fileList.size();
                                Trace.trace(TRACE_MASKD, "got " + fileCount + " files to call home");
                                for (int i = 0; i < fileCount; ++i) {
                                    FEDCFileDescriptor file = (FEDCFileDescriptor)fileList.get(i);
                                    Trace.trace(TRACE_MASKD, "file info->" + file);
                                }
                                Trace.trace(TRACE_MASKD, "add the files");
                                ArrayList<String> primaryFileList = new ArrayList<String>();
                                ArrayList<String> secondaryFileList = new ArrayList<String>();
                                for (int i = 0; i < fileCount; ++i) {
                                    FEDCFileDescriptor element = (FEDCFileDescriptor)fileList.get(i);
                                    if (element.type.equals("primary")) {
                                        Trace.trace(TRACE_MASKD, "adding " + element + " to the primary list");
                                        primaryFileList.add(element.name);
                                        ProblemDataDescriptor primaryPdd = new ProblemDataDescriptor();
                                        primaryPdd.setLocation(zipAbsoluteName);
                                        primaryPdd.setName(element.name);
                                        theProblem.addProblemDataSet(primaryPdd);
                                        continue;
                                    }
                                    Trace.trace(TRACE_MASKD, "adding " + element + " to the secondary list");
                                    secondaryFileList.add(element.name);
                                    ProblemDataDescriptor secondaryPdd = new ProblemDataDescriptor();
                                    secondaryPdd.setLocation(element.name);
                                    secondaryPdd.setName(element.name);
                                    theProblem.addProblemDataSet(secondaryPdd);
                                }
                                ArrayList failures = new ArrayList();
                                if (primaryFileList.size() > 0) {
                                    failures.addAll(vr.addToZip(sProblemNumber, primaryFileList, true, false));
                                }
                                if (secondaryFileList.size() > 0) {
                                    failures.addAll(vr.copyToDirectory(sProblemNumber, secondaryFileList));
                                }
                                Iterator iter = theProblem.getProblemDataSet().iterator();
                                while (iter.hasNext()) {
                                    pdd = (ProblemDataDescriptor)iter.next();
                                    if (failures.contains(pdd.getName())) {
                                        Trace.trace(TRACE_MASKD, "setting errorWhileCollecting for " + pdd.getName() + " to true");
                                        pdd.setErrorWhileCollecting(true);
                                    }
                                    if (pdd.isInZip()) continue;
                                    Trace.trace(TRACE_MASKD, "adjusting PDD paths.  Before: " + pdd);
                                    String name = pdd.getName();
                                    pdd.setName(dirPath + name.substring(name.lastIndexOf("/") + 1));
                                    name = pdd.getFileLocation();
                                    pdd.setLocation(dirPath + name.substring(name.lastIndexOf("/") + 1));
                                    Trace.trace(TRACE_MASKD, "adjusting PDD paths.  After: " + pdd);
                                }
                                Trace.trace(TRACE_MASKD, "the zip file name is " + zipAbsoluteName);
                                Trace.trace(TRACE_MASKD, "add the vr data to the problem");
                                problemChanged = true;
                                pdd = new ProblemDataDescriptor();
                                pdd.setLocation(zipAbsoluteName);
                                pdd.setName(zipName);
                                theProblem.addProblemDataSet(pdd);
                            }
                            catch (Exception e) {
                                Trace.trace(TRACE_MASKF, "got an exception putting the data into VR");
                                Trace.trace(TRACE_MASKF, e);
                                CommonPaLogger.logIt((short)4113, 0, (Throwable)e, false);
                            }
                            Trace.trace(TRACE_MASKF, "running the clean-up routines");
                            agent.cleanUpAnalysisExecuteModules(theProblem);
                        } else {
                            Trace.trace(TRACE_MASKF, "no ffdc to collect.");
                        }
                        if (theProblem.isGenerateAttention()) {
                            Trace.trace(TRACE_MASKF, "generate an attention");
                            ManagedObject mo = theProblem.getFailingSystem().getMO();
                            if (mo != null) {
                                LocalizableText empText = theProblem.getDescription();
                                if (empText == null) {
                                    empText = new BaseMessageText("XPA1637");
                                }
                                CommonProblemAttention anAttention = new CommonProblemAttention(mo.getObjectId(), empText);
                                anAttention.setProblem(theProblem);
                                mo.addAttention(anAttention);
                                Trace.trace(TRACE_MASKD, "add the service history entry for reported to customer");
                                try {
                                    theProblem.serviceHistoryEvent(new HistoryEntry(2));
                                    Trace.trace(TRACE_MASKD, "mark the problem as changed");
                                    problemChanged = true;
                                }
                                catch (Exception e) {
                                    Trace.trace(TRACE_MASKF, "got exception");
                                    Trace.trace(TRACE_MASKF, e);
                                    CommonPaLogger.logIt((short)4103, 1, (Throwable)e, true);
                                }
                            } else {
                                Trace.trace(TRACE_MASKT, "problem doesn't have system associated with it");
                            }
                        }
                        if (theProblem.isNotifyCustomer()) {
                            try {
                                ProblemCustomerNotifier custNotify = (ProblemCustomerNotifier)ServiceInterfaces.getFactory(theProblem.getFailingSystem(), "CustomerNotifier");
                                custNotify.notifyCustomer(theProblem);
                            }
                            catch (ServiceInterfacesException e) {
                                Trace.trace(TRACE_MASKD, "This is an optional interface.");
                                Trace.trace(TRACE_MASKD, "Platform has not implemented it.  Just go on.");
                            }
                            catch (Exception e) {
                                Trace.trace(TRACE_MASKF, "caught an exception");
                                Trace.trace(TRACE_MASKF, e);
                            }
                        }
                        if (theProblem.isCallHome()) {
                            Trace.trace(TRACE_MASKF, "want to do a call home.");
                            theProblem.serviceAuthorized();
                        }
                        if (problemChanged) {
                            Trace.trace(TRACE_MASKF, "The problem has changed. Tell the PM about it");
                            try {
                                ProblemManager.getProblemManager().changed(theProblem);
                            }
                            catch (Exception e) {
                                Trace.trace(TRACE_MASKF, "got a pm exception");
                                Trace.trace(TRACE_MASKF, e);
                            }
                        }
                    } else if (evt.getPropertyName().equals("ProblemCloseProperty")) {
                        Trace.trace(TRACE_MASKF, "got a close");
                        try {
                            ProblemCloseHandler closeHandler = (ProblemCloseHandler)ServiceInterfaces.getFactory(theProblem.getFailingSystem(), "CloseHandler");
                            closeHandler.closeProblem(theProblem);
                        }
                        catch (Exception e) {}
                    } else if (evt.getPropertyName().equals("ProblemChangedProperty")) {
                        Trace.trace(TRACE_MASKF, "got a change");
                        List dataSetList = theProblem.getProblemDataSet();
                        if (dataSetList != null) {
                            Iterator it = dataSetList.iterator();
                            boolean dataUpdated = false;
                            while (it.hasNext()) {
                                if (((ProblemDataDescriptor)it.next()).isCalledHome()) continue;
                                dataUpdated = true;
                                break;
                            }
                            if (dataUpdated) {
                                try {
                                    ProblemDataSetAdditionHandler changeHandler = (ProblemDataSetAdditionHandler)ServiceInterfaces.getFactory(theProblem.getFailingSystem(), "ChangeHandler");
                                    changeHandler.handleDataSetAddition(theProblem);
                                }
                                catch (Exception e) {}
                            }
                        }
                    } else {
                        Trace.trace(TRACE_MASKF, "got something else");
                    }
                    Trace.trace(TRACE_MASKT, "<-- CommonProblemListener.opened()");
                    break block54;
                }
                Trace.trace(TRACE_MASKT, "Not an event we care about");
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "got an exception. Catching this to keep pa from crashing.");
                Trace.trace(TRACE_MASKF, e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

